#include <sstream>
#include <fstream>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include "Riostream.h"
#include "TFile.h"
#include "TDirectory.h"
#include "TTree.h"
#include "TLeafI.h"
#include "TH1.h"
#include "TH2.h"
#include "TF1.h"
#include "TMath.h"
#include "TRandom.h"
#include "TSQLServer.h"
#include "TSystem.h"
#include "CalibTrk1Event.h"
#include "CalibTrk2Event.h"
//
#include "Digitizer.h"
#include "CRC.h"
//
#include <PamelaRun.h>
#include <physics/calorimeter/CalorimeterEvent.h>
#include <CalibCalPedEvent.h>
#include "GLTables.h"

void Digitizer::WriteRunHeader(){
  fOutputfile.write(reinterpret_cast<char*>(fDataRunHeader),sizeof(UShort_t)*fRunHeaderbuffer);
};

void Digitizer::WriteRunTrailer(){
  fOutputfile.write(reinterpret_cast<char*>(fDataRunTrailer),sizeof(UShort_t)*fRunTrailerbuffer);
};

void Digitizer::WriteData(){

  // Routine that writes the data to a binary file
  // PSCU data are already swapped
  fOutputfile.write(reinterpret_cast<char*>(fDataPSCU),sizeof(UShort_t)*fPSCUbuffer);
  // TRG
  fOutputfile.write(reinterpret_cast<char*>(fDataTrigger),sizeof(UChar_t)*fTRIGGERbuffer); //30/11/07 SO; it was 153
  // TOF
  fOutputfile.write(reinterpret_cast<char*>(fDataTof),sizeof(UChar_t)*fTOFbuffer);
  // AC
  UShort_t temp[1000000];
  memset(temp,0,sizeof(UShort_t)*1000000);
  swab(fDataAC,temp,sizeof(UShort_t)*fACbuffer);  // WE MUST SWAP THE BYTES!!!
  fOutputfile.write(reinterpret_cast<char*>(temp),sizeof(UShort_t)*fACbuffer);
  // CALO
  memset(temp,0,sizeof(UShort_t)*1000000);
  swab(fDataCALO,temp,sizeof(UShort_t)*fCALOlength); // WE MUST SWAP THE BYTES!!!
  fOutputfile.write(reinterpret_cast<char*>(temp),sizeof(UShort_t)*fCALOlength);
  // TRK
  memset(temp,0,sizeof(UShort_t)*1000000);
  swab(fDataTrack,temp,sizeof(UShort_t)*fTracklength);  // WE MUST SWAP THE BYTES!!!
  fOutputfile.write(reinterpret_cast<char*>(temp),sizeof(UShort_t)*fTracklength); 
  fTracklength=0; 
   // padding to 64 bytes
  //
  if ( fPadding ){
    fOutputfile.write(reinterpret_cast<char*>(fDataPadding),sizeof(UChar_t)*fPadding);
  };
  // S4
  memset(temp,0,sizeof(UShort_t)*1000000);
  swab(fDataS4,temp,sizeof(UShort_t)*fS4buffer);  // WE MUST SWAP THE BYTES!!!
  fOutputfile.write(reinterpret_cast<char*>(temp),sizeof(UShort_t)*fS4buffer);
  // ND
  memset(temp,0,sizeof(UShort_t)*1000000);
  swab(fDataND,temp,sizeof(UShort_t)*fNDbuffer);  // WE MUST SWAP THE BYTES!!!
  fOutputfile.write(reinterpret_cast<char*>(temp),sizeof(UShort_t)*fNDbuffer);
};
